import { Music, Mail, Phone, MapPin, Clock, Instagram, Youtube, Facebook } from 'lucide-react'
import './Footer.css'

const Footer = () => {
  return (
    <footer className="footer">
      <div className="container">
        <div className="footer-content">
          <div className="footer-section">
            <div className="footer-logo">
              <Music size={40} strokeWidth={2.5} className="footer-logo-icon" />
              <h2 className="footer-logo-text">DanceFlow</h2>
            </div>
            <p className="footer-description">
              Профессиональные танцевальные занятия для всех уровней. 
              Раскройте свой потенциал и двигайтесь в ритме музыки.
            </p>
            <div className="footer-social">
              <a href="#" className="social-link">
                <Instagram size={26} strokeWidth={2} />
              </a>
              <a href="#" className="social-link">
                <Youtube size={26} strokeWidth={2} />
              </a>
              <a href="#" className="social-link">
                <Facebook size={26} strokeWidth={2} />
              </a>
            </div>
          </div>
          <div className="footer-section">
            <h3 className="footer-title">Контакты</h3>
            <ul className="footer-links">
              <li>
                <Phone size={22} strokeWidth={2} />
                <a href="tel:+79991234567">+7 (999) 123-45-67</a>
              </li>
              <li>
                <Mail size={22} strokeWidth={2} />
                <a href="mailto:info@danceflow.ru">info@danceflow.ru</a>
              </li>
              <li>
                <MapPin size={22} strokeWidth={2} />
                <span>г. Москва, ул. Танцевальная, д. 12</span>
              </li>
            </ul>
          </div>
          <div className="footer-section">
            <h3 className="footer-title">Стили танцев</h3>
            <ul className="footer-links">
              <li><a href="#">Хип-хоп</a></li>
              <li><a href="#">Бачата</a></li>
              <li><a href="#">Зумба</a></li>
              <li><a href="#">Бальные</a></li>
            </ul>
          </div>
          <div className="footer-section">
            <h3 className="footer-title">Режим работы</h3>
            <ul className="footer-links">
              <li>
                <Clock size={20} strokeWidth={2} />
                <span>Пн-Вс: 10:00 - 22:00</span>
              </li>
            </ul>
            <div className="footer-cta">
              <p>Начните танцевать прямо сейчас</p>
              <a href="/enroll" className="footer-cta-button">Записаться</a>
            </div>
          </div>
        </div>
        <div className="footer-bottom">
          <p>&copy; 2025 DanceFlow. Все права защищены.</p>
        </div>
      </div>
    </footer>
  )
}

export default Footer

